/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;

/**
 * Network specifier object used to request a Wi-Fi Aware network. Apps should use the
 * {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder WifiAwareNetworkSpecifier.Builder} class to create an instance.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiAwareNetworkSpecifier extends android.net.NetworkSpecifier implements android.os.Parcelable {

WifiAwareNetworkSpecifier() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean canBeSatisfiedBy(android.net.NetworkSpecifier other) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get the specified channel in MHZ for this Wi-Fi Aware network specifier.
 * @see android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder#setChannelFrequencyMhz(int, boolean)
 * @return Channel frequency in Mhz. A value of 0 indicates that no channel was specified.

 * Value is 0 or greater
 */

public int getChannelFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * Get the security config specified in this Network Specifier to encrypt Wi-Fi Aware data-path
 * @return {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig WifiAwareDataPathSecurityConfig} used to encrypt the data-path

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.aware.WifiAwareDataPathSecurityConfig getWifiAwareDataPathSecurityConfig() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Check if the specified channel is required to honor or not.
 * @see android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder#setChannelFrequencyMhz(int, boolean)
 * @return true if forced to honer, false for recommend to use.
 */

public boolean isChannelRequired() { throw new RuntimeException("Stub!"); }

/** @hide */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.WifiAwareNetworkSpecifier> CREATOR;
static { CREATOR = null; }
/**
 * A builder class for a Wi-Fi Aware network specifier to set up an Aware connection with a
 * peer.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Create a builder for {@link android.net.wifi.aware.WifiAwareNetworkSpecifier WifiAwareNetworkSpecifier} used in requests to set up a
 * Wi-Fi Aware connection with a specific peer.
 * <p>
 * To set up a connection to any peer or to multiple peers use
 * {@link #Builder(android.net.wifi.aware.PublishDiscoverySession)}.
 *
 * @param discoverySession A Wi-Fi Aware discovery session in whose context the connection
 *                         is created.
 * This value cannot be {@code null}.
 * @param peerHandle The handle of the peer to which the Wi-Fi Aware connection is
 *                   requested. The peer is discovered through Wi-Fi Aware discovery. The
 *                   handle can be obtained through
 * {@link android.net.wifi.aware.DiscoverySessionCallback#onServiceDiscovered(android.net.wifi.aware.PeerHandle,byte[],java.util.List) DiscoverySessionCallback.onServiceDiscovered(PeerHandle, byte[], java.util.List)}
 *                   or
 *                   {@link android.net.wifi.aware.DiscoverySessionCallback#onMessageReceived(android.net.wifi.aware.PeerHandle,byte[]) DiscoverySessionCallback.onMessageReceived(PeerHandle, byte[])}.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.wifi.aware.DiscoverySession discoverySession, @android.annotation.NonNull android.net.wifi.aware.PeerHandle peerHandle) { throw new RuntimeException("Stub!"); }

/**
 * Create a builder for {@link android.net.wifi.aware.WifiAwareNetworkSpecifier WifiAwareNetworkSpecifier} used in requests to set up a
 * Wi-Fi Aware connection. This configuration allows connections to any peers or to
 * multiple peers (as opposed to only a specific peer with
 * {@link #Builder(android.net.wifi.aware.DiscoverySession,android.net.wifi.aware.PeerHandle)}).
 * <p>
 * Multiple connections can be triggered by this configuration and using a single request
 * via {@link android.net.ConnectivityManager#requestNetwork(android.net.NetworkRequest,android.net.ConnectivityManager.NetworkCallback) ConnectivityManager.requestNetwork(NetworkRequest, ConnectivityManager.NetworkCallback)}
 * and similar methods. Each successful connection will be signaled via the standard
 * Connectivity Manager mechanisms -
 * {@link android.net.ConnectivityManager.NetworkCallback#onAvailable(android.net.Network) ConnectivityManager.NetworkCallback.onAvailable(Network)}.
 * Calling {@link android.net.ConnectivityManager#unregisterNetworkCallback(android.net.ConnectivityManager.NetworkCallback) ConnectivityManager.unregisterNetworkCallback(ConnectivityManager.NetworkCallback)}
 * will terminate all connections.

 * @param publishDiscoverySession This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.wifi.aware.PublishDiscoverySession publishDiscoverySession) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.net.NetworkRequest.Builder#setNetworkSpecifier(NetworkSpecifier)}
 * for a WiFi Aware connection (link) to the specified peer. The
 * {@link android.net.NetworkRequest.Builder#addTransportType(int)} should be set to
 * {@link android.net.NetworkCapabilities#TRANSPORT_WIFI_AWARE}.
 * <p> The default builder constructor will initialize a NetworkSpecifier which requests an
 * open (non-encrypted) link. To request an encrypted link use the
 * {@link #setPskPassphrase(java.lang.String)} or {@link #setPmk(byte[])} builder methods.
 *
 * @return A {@link android.net.NetworkSpecifier NetworkSpecifier} to be used to construct
 * {@link android.net.NetworkRequest.Builder#setNetworkSpecifier(NetworkSpecifier)} to pass
 * to {@link android.net.ConnectivityManager#requestNetwork(android.net.NetworkRequest,
 * android.net.ConnectivityManager.NetworkCallback)}
 * [or other varieties of that API].

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier build() { throw new RuntimeException("Stub!"); }

/**
 * Configure the Channel frequency for the Wi-Fi Aware connection being requested. This
 * method is optional - if not called, then channelInMhz to use will be decided by firmware.
 * Only use this when {@link android.net.wifi.aware.WifiAwareManager#isSetChannelOnDataPathSupported() WifiAwareManager.isSetChannelOnDataPathSupported()} is true,
 * otherwise the set channelInMhz will be ignored.
 * @param channelInMhz Channel frequency in Mhz.
 * Value is 0 or greater
 * @param required If set to true, Channel request is specified and must be respected.
 *               If the firmware cannot honor the request then the data-path request
 *               is rejected. Otherwise, requested channelInMhz is a recommendation and
 *               may be overridden by the firmware.
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setChannelFrequencyMhz(int channelInMhz, boolean required) { throw new RuntimeException("Stub!"); }

/**
 * Configure security config for the Wi-Fi Aware connection being requested. This method
 * is optional - if not called, then an Open (unencrypted) connection will be created.
 * Note: this method is the superset of the {@link #setPmk(byte[])} and
 * {@link #setPskPassphrase(java.lang.String)}.
 *
 * @param securityConfig The (optional) security config to be used to encrypt the link.
 * This value cannot be {@code null}.
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder
 *         methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setDataPathSecurityConfig(@android.annotation.NonNull android.net.wifi.aware.WifiAwareDataPathSecurityConfig securityConfig) { throw new RuntimeException("Stub!"); }

/**
 * Configure the PMK for the Wi-Fi Aware connection being requested. This method
 * is optional - if not called, then an Open (unencrypted) connection will be created.
 * Note: Use
 * {@link #setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig)} to avoid
 * interoperability issues when devices support different cipher suites by explicitly
 * specifying a cipher suite as opposed to relying on a default cipher suite.
 *
 * @param pmk A PMK (pairwise master key, see IEEE 802.11i) specifying the key to use for
 *            encrypting the data-path. Use the {@link #setPskPassphrase(java.lang.String)} to
 *            specify a Passphrase.
 * This value cannot be {@code null}.
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder
 *         methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setPmk(@android.annotation.NonNull byte[] pmk) { throw new RuntimeException("Stub!"); }

/**
 * Configure the port number which will be used to create a connection over this link. This
 * configuration should only be done on the server device, e.g. the device creating the
 * {@link java.net.ServerSocket}.
 * <p>Notes:
 * <ul>
 *     <li>The server device must be the Publisher device!
 *     <li>The port information can only be specified on secure links, specified using
 *     {@link #setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig)}
 * </ul>
 *
 * @param port A positive integer indicating the port to be used for communication.
 * Value is between 0 and 65535 inclusive
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder
 *         methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setPort(int port) { throw new RuntimeException("Stub!"); }

/**
 * Configure the PSK Passphrase for the Wi-Fi Aware connection being requested. This method
 * is optional - if not called, then an Open (unencrypted) connection will be created.
 * Note: Use
 * {@link #setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig)} to avoid
 * interoperability issues when devices support different cipher suites by explicitly
 * specifying a cipher suite as opposed to relying on a default cipher suite.
 * {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder#Builder(int) WifiAwareDataPathSecurityConfig.Builder.Builder(int)}
 *
 * @param pskPassphrase The (optional) passphrase to be used to encrypt the link. Use the
 *                      {@link #setPmk(byte[])} to specify a PMK.
 * This value cannot be {@code null}.
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder
 *         methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setPskPassphrase(@android.annotation.NonNull java.lang.String pskPassphrase) { throw new RuntimeException("Stub!"); }

/**
 * Configure the transport protocol which will be used to create a connection over this
 * link. This configuration should only be done on the server device, e.g. the device
 * creating the {@link java.net.ServerSocket} for TCP.
 * <p>Notes:
 * <ul>
 *     <li>The server device must be the Publisher device!
 *     <li>The transport protocol information can only be specified on secure links,
 *     specified using
 *     {@link #setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig)}.
 * </ul>
 * The transport protocol number is assigned by the Internet Assigned Numbers Authority
 * (IANA) https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml.
 *
 * @param transportProtocol The transport protocol to be used for communication.
 * Value is between 0 and 255 inclusive
 * @return the current {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder Builder} builder, enabling chaining of builder
 *         methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder setTransportProtocol(int transportProtocol) { throw new RuntimeException("Stub!"); }
}

}

