/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv.ad;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class TvAdService extends android.app.Service {

public TvAdService() { throw new RuntimeException("Stub!"); }

public void onAppLinkCommand(@android.annotation.NonNull android.os.Bundle command) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.os.IBinder onBind(@android.annotation.Nullable android.content.Intent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.media.tv.ad.TvAdService.Session onCreateSession(@android.annotation.NonNull java.lang.String serviceId, @android.annotation.NonNull java.lang.String type);

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String SERVICE_INTERFACE = "android.media.tv.ad.TvAdService";

public static final java.lang.String SERVICE_META_DATA = "android.media.tv.ad.service";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Session implements android.view.KeyEvent.Callback {

public Session(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

public boolean isMediaViewEnabled() { throw new RuntimeException("Stub!"); }

public void layoutSurface(int left, int top, int right, int bottom) { throw new RuntimeException("Stub!"); }

public void notifySessionStateChanged(int state, int err) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.view.View onCreateMediaView() { throw new RuntimeException("Stub!"); }

public void onCurrentChannelUri(@android.annotation.Nullable android.net.Uri channelUri) { throw new RuntimeException("Stub!"); }

public void onCurrentTvInputId(@android.annotation.Nullable java.lang.String inputId) { throw new RuntimeException("Stub!"); }

public void onCurrentVideoBounds(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

public void onError(@android.annotation.NonNull java.lang.String errMsg, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public boolean onGenericMotionEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyDown(int keyCode, @android.annotation.Nullable android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyLongPress(int keyCode, @android.annotation.Nullable android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyMultiple(int keyCode, int count, @android.annotation.Nullable android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyUp(int keyCode, @android.annotation.Nullable android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public void onMediaViewSizeChanged(int width, int height) { throw new RuntimeException("Stub!"); }

public abstract void onRelease();

public void onResetAdService() { throw new RuntimeException("Stub!"); }

public abstract boolean onSetSurface(@android.annotation.Nullable android.view.Surface surface);

public void onSigningResult(@android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull byte[] result) { throw new RuntimeException("Stub!"); }

public void onStartAdService() { throw new RuntimeException("Stub!"); }

public void onStopAdService() { throw new RuntimeException("Stub!"); }

public void onSurfaceChanged(int format, int width, int height) { throw new RuntimeException("Stub!"); }

public boolean onTouchEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public void onTrackInfoList(@android.annotation.NonNull java.util.List<android.media.tv.TvTrackInfo> tracks) { throw new RuntimeException("Stub!"); }

public boolean onTrackballEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public void onTvInputSessionData(@android.annotation.NonNull java.lang.String type, @android.annotation.NonNull android.os.Bundle data) { throw new RuntimeException("Stub!"); }

public void onTvMessage(int type, @android.annotation.NonNull android.os.Bundle data) { throw new RuntimeException("Stub!"); }

public void requestCurrentChannelUri() { throw new RuntimeException("Stub!"); }

public void requestCurrentTvInputId() { throw new RuntimeException("Stub!"); }

public void requestCurrentVideoBounds() { throw new RuntimeException("Stub!"); }

public void requestSigning(@android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull java.lang.String algorithm, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public void requestTrackInfoList() { throw new RuntimeException("Stub!"); }

public void sendTvAdSessionData(@android.annotation.NonNull java.lang.String type, @android.annotation.NonNull android.os.Bundle data) { throw new RuntimeException("Stub!"); }

public void setMediaViewEnabled(boolean enable) { throw new RuntimeException("Stub!"); }
}

}

