/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.metrics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlaybackMetrics implements android.os.Parcelable {

PlaybackMetrics() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getAudioUnderrunCount() { throw new RuntimeException("Stub!"); }

public int getContentType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getDrmSessionId() { throw new RuntimeException("Stub!"); }

public int getDrmType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public long[] getExperimentIds() { throw new RuntimeException("Stub!"); }

public long getLocalBytesRead() { throw new RuntimeException("Stub!"); }

public long getMediaDurationMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getMetricsBundle() { throw new RuntimeException("Stub!"); }

public long getNetworkBytesRead() { throw new RuntimeException("Stub!"); }

public long getNetworkTransferDurationMillis() { throw new RuntimeException("Stub!"); }

public int getPlaybackType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPlayerName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPlayerVersion() { throw new RuntimeException("Stub!"); }

public int getStreamSource() { throw new RuntimeException("Stub!"); }

public int getStreamType() { throw new RuntimeException("Stub!"); }

public int getVideoFramesDropped() { throw new RuntimeException("Stub!"); }

public int getVideoFramesPlayed() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONTENT_TYPE_AD = 2; // 0x2

public static final int CONTENT_TYPE_MAIN = 1; // 0x1

public static final int CONTENT_TYPE_OTHER = 3; // 0x3

public static final int CONTENT_TYPE_UNKNOWN = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.metrics.PlaybackMetrics> CREATOR;
static { CREATOR = null; }

public static final int DRM_TYPE_CLEARKEY = 6; // 0x6

public static final int DRM_TYPE_NONE = 0; // 0x0

public static final int DRM_TYPE_OTHER = 1; // 0x1

public static final int DRM_TYPE_PLAY_READY = 2; // 0x2

public static final int DRM_TYPE_WIDEVINE_L1 = 3; // 0x3

public static final int DRM_TYPE_WIDEVINE_L3 = 4; // 0x4

public static final int DRM_TYPE_WV_L3_FALLBACK = 5; // 0x5

public static final int PLAYBACK_TYPE_LIVE = 2; // 0x2

public static final int PLAYBACK_TYPE_OTHER = 3; // 0x3

public static final int PLAYBACK_TYPE_UNKNOWN = 0; // 0x0

public static final int PLAYBACK_TYPE_VOD = 1; // 0x1

public static final int STREAM_SOURCE_DEVICE = 2; // 0x2

public static final int STREAM_SOURCE_MIXED = 3; // 0x3

public static final int STREAM_SOURCE_NETWORK = 1; // 0x1

public static final int STREAM_SOURCE_UNKNOWN = 0; // 0x0

public static final int STREAM_TYPE_DASH = 3; // 0x3

public static final int STREAM_TYPE_HLS = 4; // 0x4

public static final int STREAM_TYPE_OTHER = 1; // 0x1

public static final int STREAM_TYPE_PROGRESSIVE = 2; // 0x2

public static final int STREAM_TYPE_SS = 5; // 0x5

public static final int STREAM_TYPE_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder addExperimentId(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setAudioUnderrunCount(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setContentType(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setDrmSessionId(@android.annotation.NonNull byte[] drmSessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setDrmType(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setLocalBytesRead(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setMediaDurationMillis(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setMetricsBundle(@android.annotation.NonNull android.os.Bundle metricsBundle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setNetworkBytesRead(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setNetworkTransferDurationMillis(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setPlaybackType(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setPlayerName(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setPlayerVersion(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setStreamSource(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setStreamType(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setVideoFramesDropped(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackMetrics.Builder setVideoFramesPlayed(int value) { throw new RuntimeException("Stub!"); }
}

}

