/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media.metrics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaItemInfo implements android.os.Parcelable {

MediaItemInfo() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getAudioChannelCount() { throw new RuntimeException("Stub!"); }

public long getAudioSampleCount() { throw new RuntimeException("Stub!"); }

public int getAudioSampleRateHz() { throw new RuntimeException("Stub!"); }

public long getClipDurationMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getCodecNames() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getContainerMimeType() { throw new RuntimeException("Stub!"); }

public long getDataTypes() { throw new RuntimeException("Stub!"); }

public long getDurationMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getSampleMimeTypes() { throw new RuntimeException("Stub!"); }

public int getSourceType() { throw new RuntimeException("Stub!"); }

public int getVideoDataSpace() { throw new RuntimeException("Stub!"); }

public float getVideoFrameRate() { throw new RuntimeException("Stub!"); }

public long getVideoSampleCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.util.Size getVideoSize() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.metrics.MediaItemInfo> CREATOR;
static { CREATOR = null; }

public static final long DATA_TYPE_AUDIO = 4L; // 0x4L

public static final long DATA_TYPE_DEPTH = 16L; // 0x10L

public static final long DATA_TYPE_GAIN_MAP = 32L; // 0x20L

public static final long DATA_TYPE_GAPLESS = 256L; // 0x100L

public static final long DATA_TYPE_HIGH_DYNAMIC_RANGE_VIDEO = 1024L; // 0x400L

public static final long DATA_TYPE_HIGH_FRAME_RATE = 64L; // 0x40L

public static final long DATA_TYPE_IMAGE = 1L; // 0x1L

public static final long DATA_TYPE_METADATA = 8L; // 0x8L

public static final long DATA_TYPE_SPATIAL_AUDIO = 512L; // 0x200L

public static final long DATA_TYPE_SPEED_SETTING_CUE_POINTS = 128L; // 0x80L

public static final long DATA_TYPE_VIDEO = 2L; // 0x2L

public static final int SOURCE_TYPE_CAMERA = 2; // 0x2

public static final int SOURCE_TYPE_EDITING_SESSION = 3; // 0x3

public static final int SOURCE_TYPE_GALLERY = 1; // 0x1

public static final int SOURCE_TYPE_GENERATED = 7; // 0x7

public static final int SOURCE_TYPE_LOCAL_FILE = 4; // 0x4

public static final int SOURCE_TYPE_REMOTE_FILE = 5; // 0x5

public static final int SOURCE_TYPE_REMOTE_LIVE_STREAM = 6; // 0x6

public static final int SOURCE_TYPE_UNSPECIFIED = 0; // 0x0

public static final int VALUE_UNSPECIFIED = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder addCodecName(@android.annotation.NonNull java.lang.String codecName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder addDataType(long dataType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder addSampleMimeType(@android.annotation.NonNull java.lang.String mimeType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setAudioChannelCount(int audioChannelCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setAudioSampleCount(long audioSampleCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setAudioSampleRateHz(int audioSampleRateHz) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setClipDurationMillis(long clipDurationMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setContainerMimeType(@android.annotation.NonNull java.lang.String containerMimeType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setDurationMillis(long durationMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setSourceType(int sourceType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setVideoDataSpace(int videoDataSpace) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setVideoFrameRate(float videoFrameRate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setVideoSampleCount(long videoSampleCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.MediaItemInfo.Builder setVideoSize(@android.annotation.NonNull android.util.Size videoSize) { throw new RuntimeException("Stub!"); }
}

}

