/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * A physical device (such as phone, watch, scale, or chest strap) which captured associated health
 * data point.
 *
 * <p>Device needs to be populated by users of the API. Metadata fields not provided by clients will
 * remain absent.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Device {

Device() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * @return The device manufacturer if set, null otherwise
 */

@android.annotation.Nullable
public java.lang.String getManufacturer() { throw new RuntimeException("Stub!"); }

/**
 * @return The device model if set, null otherwise
 */

@android.annotation.Nullable
public java.lang.String getModel() { throw new RuntimeException("Stub!"); }

/**
 * @return The device type if set {@code DEVICE_TYPE_UNKNOWN} otherwise

 * Value is {@link android.health.connect.datatypes.Device#DEVICE_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_WATCH}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_PHONE}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_SCALE}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_RING}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_HEAD_MOUNTED}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_FITNESS_BAND}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_CHEST_STRAP}, or {@link android.health.connect.datatypes.Device#DEVICE_TYPE_SMART_DISPLAY}
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

public static final int DEVICE_TYPE_CHEST_STRAP = 7; // 0x7

public static final int DEVICE_TYPE_FITNESS_BAND = 6; // 0x6

public static final int DEVICE_TYPE_HEAD_MOUNTED = 5; // 0x5

public static final int DEVICE_TYPE_PHONE = 2; // 0x2

public static final int DEVICE_TYPE_RING = 4; // 0x4

public static final int DEVICE_TYPE_SCALE = 3; // 0x3

public static final int DEVICE_TYPE_SMART_DISPLAY = 8; // 0x8

public static final int DEVICE_TYPE_UNKNOWN = 0; // 0x0

public static final int DEVICE_TYPE_WATCH = 1; // 0x1
/**
 * @see android.health.connect.datatypes.Device
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build and return {@link android.health.connect.datatypes.Device Device} object
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Device build() { throw new RuntimeException("Stub!"); }

/**
 * Sets an optional client supplied manufacturer of the device
 * @param manufacturer This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Device.Builder setManufacturer(@android.annotation.Nullable java.lang.String manufacturer) { throw new RuntimeException("Stub!"); }

/**
 * Sets an optional client supplied model of the device
 * @param model This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Device.Builder setModel(@android.annotation.Nullable java.lang.String model) { throw new RuntimeException("Stub!"); }

/**
 * Sets an optional client supplied type of the device
 * @param type Value is {@link android.health.connect.datatypes.Device#DEVICE_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_WATCH}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_PHONE}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_SCALE}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_RING}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_HEAD_MOUNTED}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_FITNESS_BAND}, {@link android.health.connect.datatypes.Device#DEVICE_TYPE_CHEST_STRAP}, or {@link android.health.connect.datatypes.Device#DEVICE_TYPE_SMART_DISPLAY}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Device.Builder setType(int type) { throw new RuntimeException("Stub!"); }
}

}

