/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.units.Energy;

/**
 * Captures the estimated active energy burned by the user (in kilocalories), excluding basal
 * metabolic rate (BMR).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ActiveCaloriesBurnedRecord extends android.health.connect.datatypes.IntervalRecord {

ActiveCaloriesBurnedRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return energy in {@link android.health.connect.datatypes.units.Energy Energy} unit.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Energy getEnergy() { throw new RuntimeException("Stub!"); }

/**
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to get total active calories burnt using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Energy> ACTIVE_CALORIES_TOTAL;
static { ACTIVE_CALORIES_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.ActiveCaloriesBurnedRecord ActiveCaloriesBurnedRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity
 * This value cannot be {@code null}.
 * @param energy Energy in {@link android.health.connect.datatypes.units.Energy Energy} unit. Required field. Valid range: 0-1000000 kcal.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, @android.annotation.NonNull android.health.connect.datatypes.units.Energy energy) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.ActiveCaloriesBurnedRecord ActiveCaloriesBurnedRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActiveCaloriesBurnedRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActiveCaloriesBurnedRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActiveCaloriesBurnedRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActiveCaloriesBurnedRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActiveCaloriesBurnedRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }
}

}

