/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.changelog;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;

/**
 * Response class for {@link android.health.connect.HealthConnectManager#getChangeLogs HealthConnectManager.getChangeLogs} This is the response to clients
 * fetching changes.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChangeLogsResponse implements android.os.Parcelable {

ChangeLogsResponse() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns delete logs for records that have been deleted post the time when the token was
 * requested from {@link android.health.connect.HealthConnectManager#getChangeLogToken HealthConnectManager.getChangeLogToken}.
 *
 * <p>This contains record ids of deleted records and the timestamps when the records were
 * deleted.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.changelog.ChangeLogsResponse.DeletedLog> getDeletedLogs() { throw new RuntimeException("Stub!"); }

/**
 * Returns token for future reads using {@link android.health.connect.HealthConnectManager#getChangeLogs HealthConnectManager.getChangeLogs}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNextChangesToken() { throw new RuntimeException("Stub!"); }

/**
 * Returns records that have been updated or inserted post the time when the given token was
 * generated.
 *
 * <p>Clients can use the last modified time of the record to check when the record was
 * modified.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.Record> getUpsertedRecords() { throw new RuntimeException("Stub!"); }

/** Returns whether there are more pages available for read. */

public boolean hasMorePages() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.changelog.ChangeLogsResponse> CREATOR;
static { CREATOR = null; }
/**
 * A change log holds the {@link android.health.connect.datatypes.Metadata#getId() Metadata.getId()} of a deleted Record. For privacy, only unique
 * identifiers of deleted records are returned.
 *
 * <p>Clients holding copies of data from Health Connect should keep a copy of these unique
 * identifiers along with their contents. When receiving a {@link android.health.connect.changelog.ChangeLogsResponse.DeletedLog DeletedLog} in {@link android.health.connect.changelog.ChangeLogsResponse ChangeLogsResponse}, use the identifiers to delete copy of the data.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DeletedLog {

/**
 * @param deletedRecordId This value cannot be {@code null}.
 */

public DeletedLog(@android.annotation.NonNull java.lang.String deletedRecordId, long deletedTime) { throw new RuntimeException("Stub!"); }

/**
 * Returns record id of the record deleted.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDeletedRecordId() { throw new RuntimeException("Stub!"); }

/**
 * Returns timestamp when the record was deleted.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getDeletedTime() { throw new RuntimeException("Stub!"); }
}

}

