/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect;

import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;

/**
 * An initial read request with specified filters for {@link android.health.connect.HealthConnectManager#readMedicalResources  }.
 *
 * <p>On receiving the response, if {@link android.health.connect.ReadMedicalResourcesResponse#getNextPageToken() ReadMedicalResourcesResponse.getNextPageToken()} is not
 * {@code null}, then use the next token with {@link android.health.connect.ReadMedicalResourcesPageRequest ReadMedicalResourcesPageRequest} to read the
 * next page.
 *
 * <p>Example usage:
 *
 * <pre>{@code
 * ReadMedicalResourcesInitialRequest initialRequest
 *     = new ReadMedicalResourcesInitialRequest.Builder(...).build();
 * ReadMedicalResourcesResponse response = makeRequest(initialRequest);
 * String pageToken = response.getNextPageToken();
 *
 * while (pageToken != null) {
 *     ReadMedicalResourcesPageRequest pageRequest = new ReadMedicalResourcesPageRequest(pageToken);
 *     response = makeRequest(pageRequest);
 *     pageToken = response.getNextPageToken();
 * }
 * }</pre>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReadMedicalResourcesInitialRequest extends android.health.connect.ReadMedicalResourcesRequest {

ReadMedicalResourcesInitialRequest() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of IDs of the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} filter to read from, or an empty set
 * for no filter.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getDataSourceIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns the medical resource type.
 * @return Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 */

public int getMedicalResourceType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.ReadMedicalResourcesInitialRequest ReadMedicalResourcesInitialRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.ReadMedicalResourcesInitialRequest ReadMedicalResourcesInitialRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.ReadMedicalResourcesInitialRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.ReadMedicalResourcesInitialRequest.Builder ReadMedicalResourcesInitialRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.ReadMedicalResourcesInitialRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.ReadMedicalResourcesInitialRequest.Builder ReadMedicalResourcesInitialRequest.Builder} instance.
 *
 * @param medicalResourceType The medical resource type.
 * Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 * @throws java.lang.IllegalArgumentException if the provided {@code medicalResourceType} is not a
 *     supported type.
 */

public Builder(int medicalResourceType) { throw new RuntimeException("Stub!"); }

/**
 * Adds the data source ID based on which the read operation is to be performed. This should
 * be an ID of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}.
 *
 * <p>If no {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} ID is added, then {@link android.health.connect.datatypes.MedicalResource MedicalResource}s from all
 * {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s will be read.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID.
 
 * @param dataSourceId This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest.Builder addDataSourceId(@android.annotation.NonNull java.lang.String dataSourceId) { throw new RuntimeException("Stub!"); }

/**
 * Adds all data source IDs based on which the read operation is to be performed. This
 * should all be IDs of existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s.
 *
 * <p>If no {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} IDs are added, then {@link android.health.connect.datatypes.MedicalResource MedicalResource}s from all
 * {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s will be read.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceIds} is null, or any ID
 *     in it is not valid.
 
 * @param dataSourceIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest.Builder addDataSourceIds(@android.annotation.NonNull java.util.Set<java.lang.String> dataSourceIds) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.ReadMedicalResourcesInitialRequest ReadMedicalResourcesInitialRequest} with the specified
 * parameters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Clears all the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} filters for this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest.Builder clearDataSourceIds() { throw new RuntimeException("Stub!"); }

/**
 * Sets the medical resource type.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code medicalResourceType} is not a
 *     supported type.
 
 * @param medicalResourceType Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest.Builder setMedicalResourceType(int medicalResourceType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum number of {@code MedicalResource}s to be returned by the read operation.
 *
 * <p>If not set, default to 1000.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code pageSize} is less than 1 or more
 *     than 5000.
 
 * @param pageSize Value is between MINIMUM_PAGE_SIZE and MAXIMUM_PAGE_SIZE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesInitialRequest.Builder setPageSize(int pageSize) { throw new RuntimeException("Stub!"); }
}

}

