/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;


/** Specification of local time range for health connect requests. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LocalTimeRangeFilter implements android.health.connect.TimeRangeFilter {

LocalTimeRangeFilter() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return local end time of this filter

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.LocalDateTime getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * @return local start time of this filter

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.LocalDateTime getStartTime() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return a boolean value indicating if the filter is bound or not.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public boolean isBounded() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.LocalTimeRangeFilter LocalTimeRangeFilter} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds {@link android.health.connect.TimeRangeFilter TimeRangeFilter}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.LocalTimeRangeFilter build() { throw new RuntimeException("Stub!"); }

/**
 * @param localEndTime represents local end time of this filter
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.LocalTimeRangeFilter.Builder setEndTime(@android.annotation.Nullable java.time.LocalDateTime localEndTime) { throw new RuntimeException("Stub!"); }

/**
 * @param localStartTime represents local start time of this filter
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.LocalTimeRangeFilter.Builder setStartTime(@android.annotation.Nullable java.time.LocalDateTime localStartTime) { throw new RuntimeException("Stub!"); }
}

}

