/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.MedicalDataSource;

/**
 * A create request for {@link android.health.connect.HealthConnectManager#getMedicalDataSources HealthConnectManager.getMedicalDataSources}.
 *
 * <p>If no {@link android.health.connect.GetMedicalDataSourcesRequest#getPackageNames() package names} are set, requests
 * all {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s from all packages. Otherwise the request is limited to the
 * requested package names.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetMedicalDataSourcesRequest implements android.os.Parcelable {

GetMedicalDataSourcesRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the package names for which {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s are being requested, or an
 * empty set for no filter.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getPackageNames() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.GetMedicalDataSourcesRequest> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.GetMedicalDataSourcesRequest GetMedicalDataSourcesRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Constructs a new {@link android.health.connect.GetMedicalDataSourcesRequest.Builder GetMedicalDataSourcesRequest.Builder} with no filters set. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.GetMedicalDataSourcesRequest GetMedicalDataSourcesRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.GetMedicalDataSourcesRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.GetMedicalDataSourcesRequest.Builder GetMedicalDataSourcesRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.GetMedicalDataSourcesRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Adds a package name to limit this request to.
 *
 * <p>If the list of package names is empty, {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}s for all packages
 * will be requested. Otherwise only those for the added package names are requested.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code packageName} is not valid.
 
 * @param packageName This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.GetMedicalDataSourcesRequest.Builder addPackageName(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.GetMedicalDataSourcesRequest GetMedicalDataSourcesRequest} with the specified
 * parameters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.GetMedicalDataSourcesRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Clears all package names.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.GetMedicalDataSourcesRequest.Builder clearPackageNames() { throw new RuntimeException("Stub!"); }
}

}

