/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CameraCaptureSession implements java.lang.AutoCloseable {

public CameraCaptureSession() { throw new RuntimeException("Stub!"); }

public abstract void abortCaptures() throws android.hardware.camera2.CameraAccessException;

public abstract int capture(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.Nullable android.hardware.camera2.CameraCaptureSession.CaptureCallback listener, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

public abstract int captureBurst(@android.annotation.NonNull java.util.List<android.hardware.camera2.CaptureRequest> requests, @android.annotation.Nullable android.hardware.camera2.CameraCaptureSession.CaptureCallback listener, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

public int captureBurstRequests(@android.annotation.NonNull java.util.List<android.hardware.camera2.CaptureRequest> requests, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.CaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public int captureSingleRequest(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.CaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public abstract void close();

public abstract void finalizeOutputConfigurations(java.util.List<android.hardware.camera2.params.OutputConfiguration> outputConfigs) throws android.hardware.camera2.CameraAccessException;

@android.annotation.NonNull
public abstract android.hardware.camera2.CameraDevice getDevice();

@android.annotation.Nullable
public abstract android.view.Surface getInputSurface();

public abstract boolean isReprocessable();

public abstract void prepare(@android.annotation.NonNull android.view.Surface surface) throws android.hardware.camera2.CameraAccessException;

public abstract int setRepeatingBurst(@android.annotation.NonNull java.util.List<android.hardware.camera2.CaptureRequest> requests, @android.annotation.Nullable android.hardware.camera2.CameraCaptureSession.CaptureCallback listener, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

public int setRepeatingBurstRequests(@android.annotation.NonNull java.util.List<android.hardware.camera2.CaptureRequest> requests, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.CaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public abstract int setRepeatingRequest(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.Nullable android.hardware.camera2.CameraCaptureSession.CaptureCallback listener, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

public int setSingleRepeatingRequest(@android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.CaptureCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public abstract void stopRepeating() throws android.hardware.camera2.CameraAccessException;

public boolean supportsOfflineProcessing(@android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.hardware.camera2.CameraOfflineSession switchToOffline(@android.annotation.NonNull java.util.Collection<android.view.Surface> offlineSurfaces, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.hardware.camera2.CameraOfflineSession.CameraOfflineSessionCallback listener) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public void updateOutputConfiguration(android.hardware.camera2.params.OutputConfiguration config) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class CaptureCallback {

public CaptureCallback() { throw new RuntimeException("Stub!"); }

public void onCaptureBufferLost(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull android.view.Surface target, long frameNumber) { throw new RuntimeException("Stub!"); }

public void onCaptureCompleted(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull android.hardware.camera2.TotalCaptureResult result) { throw new RuntimeException("Stub!"); }

public void onCaptureFailed(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull android.hardware.camera2.CaptureFailure failure) { throw new RuntimeException("Stub!"); }

public void onCaptureProgressed(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, @android.annotation.NonNull android.hardware.camera2.CaptureResult partialResult) { throw new RuntimeException("Stub!"); }

public void onCaptureSequenceAborted(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, int sequenceId) { throw new RuntimeException("Stub!"); }

public void onCaptureSequenceCompleted(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, int sequenceId, long frameNumber) { throw new RuntimeException("Stub!"); }

public void onCaptureStarted(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, long timestamp, long frameNumber) { throw new RuntimeException("Stub!"); }

public void onReadoutStarted(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.hardware.camera2.CaptureRequest request, long timestamp, long frameNumber) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class StateCallback {

public StateCallback() { throw new RuntimeException("Stub!"); }

public void onActive(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session) { throw new RuntimeException("Stub!"); }

public void onCaptureQueueEmpty(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session) { throw new RuntimeException("Stub!"); }

public void onClosed(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session) { throw new RuntimeException("Stub!"); }

public abstract void onConfigureFailed(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session);

public abstract void onConfigured(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session);

public void onReady(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session) { throw new RuntimeException("Stub!"); }

public void onSurfacePrepared(@android.annotation.NonNull android.hardware.camera2.CameraCaptureSession session, @android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }
}

}

