/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * Represents a supported source codec type for a Bluetooth A2DP device. See {@link android.bluetooth.BluetoothA2dp#getSupportedCodecTypes  }. The codec type is uniquely identified by its name and
 * codec identifier.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothCodecType implements android.os.Parcelable {

BluetoothCodecType() { throw new RuntimeException("Stub!"); }

/**
 * @return 0
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec unique identifier.
 *
 * <p>The codec identifier is 40 bits:
 *
 * <ul>
 *   <li>Bits 0-7: Audio Codec ID, as defined by [ID 6.5.1]
 *       <ul>
 *         <li>0x00: SBC
 *         <li>0x02: AAC
 *         <li>0xFF: Vendor
 *       </ul>
 *   <li>Bits 8-23: Company ID, set to 0, if octet 0 is not 0xFF.
 *   <li>Bits 24-39: Vendor-defined codec ID, set to 0, if octet 0 is not 0xFF.
 * </ul>
 */

public long getCodecId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec name.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getCodecName() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Returns if the codec type is mandatory in the Bluetooth specification. */

public boolean isMandatoryCodec() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** AAC codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_AAC = 2L; // 0x2L

/** AptX codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_APTX = 16797695L; // 0x1004fffL

/** Aptx HD codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_APTX_HD = 604035071L; // 0x2400d7ffL

/** LDAC codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_LDAC = -1442763265L; // 0xffffffffaa012dffL

/** Opus codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_OPUS = 16834815L; // 0x100e0ffL

/** SBC codec identifier. See {@link android.bluetooth.BluetoothCodecType#getCodecId BluetoothCodecType.getCodecId}. */

public static final long CODEC_ID_SBC = 0L; // 0x0L

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothCodecType> CREATOR;
static { CREATOR = null; }
}

