/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.List;
import java.util.Map;

/**
 * This class represents one of the results obtained from an AppSearch query.
 *
 * <p>This allows clients to obtain:
 *
 * <ul>
 *   <li>The document which matched, using {@link #getGenericDocument}
 *   <li>Information about which properties in the document matched, and "snippet" information
 *       containing textual summaries of the document's matches, using {@link #getMatchInfos}
 * </ul>
 *
 * <p>"Snippet" refers to a substring of text from the content of document that is returned as a
 * part of search result.
 *
 * @see android.app.appsearch.SearchResults
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchResult implements android.os.Parcelable {

SearchResult() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Contains the database name that stored the {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * @return Name of the database within which the document is stored

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDatabaseName() { throw new RuntimeException("Stub!"); }

/**
 * Contains the matching {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * @return Document object which matched the query.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GenericDocument getGenericDocument() { throw new RuntimeException("Stub!"); }

/**
 * Returns the informational ranking signals of the {@link android.app.appsearch.GenericDocument GenericDocument}, according to the
 * expressions added in {@link android.app.appsearch.SearchSpec.Builder#addInformationalRankingExpressions SearchSpec.Builder.addInformationalRankingExpressions}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.Double> getInformationalRankingSignals() { throw new RuntimeException("Stub!"); }

/**
 * Gets a list of {@link android.app.appsearch.SearchResult SearchResult} joined from the join operation.
 *
 * <p>These joined documents match the outer document as specified in the {@link android.app.appsearch.JoinSpec JoinSpec} with
 * parentPropertyExpression and childPropertyExpression. They are ordered according to the
 * {@link android.app.appsearch.JoinSpec#getNestedSearchSpec JoinSpec.getNestedSearchSpec}, and as many SearchResults as specified by {@link android.app.appsearch.JoinSpec#getMaxJoinedResultCount  } will be returned. If no {@link android.app.appsearch.JoinSpec JoinSpec} was specified,
 * this returns an empty list.
 *
 * <p>This method is inefficient to call repeatedly, as new {@link android.app.appsearch.SearchResult SearchResult} objects are
 * created each time.
 *
 * @return a List of SearchResults containing joined documents.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.SearchResult> getJoinedResults() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of {@link android.app.appsearch.SearchResult.MatchInfo MatchInfo}s providing information about how the document in {@link
 * #getGenericDocument} matched the query.
 *
 * @return List of matches based on {@link android.app.appsearch.SearchSpec SearchSpec}. If snippeting is disabled using {@link android.app.appsearch.SearchSpec.Builder#setSnippetCount      } or {@link android.app.appsearch.SearchSpec.Builder#setSnippetCountPerProperty      }, for all results after that value, this
 *     method returns an empty list.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.SearchResult.MatchInfo> getMatchInfos() { throw new RuntimeException("Stub!"); }

/**
 * Contains the package name of the app that stored the {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * @return Package name that stored the document

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the map from schema type names to the list of their parent types.
 *
 * <p>The map includes entries for the {@link android.app.appsearch.GenericDocument GenericDocument}'s own type and all of the nested
 * documents' types. Child types are guaranteed to appear before parent types in each list.
 *
 * <p>Parent types include transitive parents.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getParentTypeMap() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranking signal of the {@link android.app.appsearch.GenericDocument GenericDocument}, according to the ranking strategy
 * set in {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(int) SearchSpec.Builder.setRankingStrategy(int)}.
 *
 * <p>The meaning of the ranking signal and its value is determined by the selected ranking
 * strategy:
 *
 * <ul>
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_NONE SearchSpec.RANKING_STRATEGY_NONE} - this value will be 0
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_DOCUMENT_SCORE SearchSpec.RANKING_STRATEGY_DOCUMENT_SCORE} - the value returned by calling
 *       {@link android.app.appsearch.GenericDocument#getScore() GenericDocument.getScore()} on the document returned by {@link
 *       #getGenericDocument()}
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_CREATION_TIMESTAMP SearchSpec.RANKING_STRATEGY_CREATION_TIMESTAMP} - the value returned by calling
 *       {@link android.app.appsearch.GenericDocument#getCreationTimestampMillis() GenericDocument.getCreationTimestampMillis()} on the document returned by {@link
 *       #getGenericDocument()}
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_RELEVANCE_SCORE SearchSpec.RANKING_STRATEGY_RELEVANCE_SCORE} - an arbitrary double value where a
 *       higher value means more relevant
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_COUNT SearchSpec.RANKING_STRATEGY_USAGE_COUNT} - the number of times usage has been
 *       reported for the document returned by {@link #getGenericDocument()}
 *   <li>{@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP SearchSpec.RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP} - the timestamp of the
 *       most recent usage that has been reported for the document returned by {@link
 *       #getGenericDocument()}
 * </ul>
 *
 * @return Ranking signal of the document
 */

public double getRankingSignal() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchResult> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.app.appsearch.SearchResult SearchResult} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new builder for {@link android.app.appsearch.SearchResult SearchResult} objects.
 *
 * @param packageName the package name the matched document belongs to
 * This value cannot be {@code null}.
 * @param databaseName the database name the matched document belongs to.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName) { throw new RuntimeException("Stub!"); }

/**
 * Adds the informational ranking signal of the matched document in this SearchResult.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder addInformationalRankingSignal(double rankingSignal) { throw new RuntimeException("Stub!"); }

/**
 * Adds a {@link android.app.appsearch.SearchResult SearchResult} that was joined by the {@link android.app.appsearch.JoinSpec JoinSpec}.
 *
 * @param joinedResult The joined SearchResult to add.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder addJoinedResult(@android.annotation.NonNull android.app.appsearch.SearchResult joinedResult) { throw new RuntimeException("Stub!"); }

/**
 * Adds another match to this SearchResult.
 * @param matchInfo This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder addMatchInfo(@android.annotation.NonNull android.app.appsearch.SearchResult.MatchInfo matchInfo) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchResult SearchResult}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the document which matched.
 * @param document This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder setGenericDocument(@android.annotation.NonNull android.app.appsearch.GenericDocument document) { throw new RuntimeException("Stub!"); }

/**
 * Sets the map from schema type names to the list of their parent types.
 *
 * <p>The map should include entries for the {@link android.app.appsearch.GenericDocument GenericDocument}'s own type and all of
 * the nested documents' types.
 *
 * <p>Child types must appear before parent types in each list. Otherwise, the
 * GenericDocument's toDocumentClass method (an AndroidX-only API) may not correctly
 * identify the most concrete type. This could lead to unintended deserialization into a
 * more general type instead of a more specific type.
 *
 * <p>Parent types should include transitive parents.
 
 * @param parentTypeMap This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder setParentTypeMap(@android.annotation.NonNull java.util.Map<java.lang.String,java.util.List<java.lang.String>> parentTypeMap) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ranking signal of the matched document in this SearchResult.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.Builder setRankingSignal(double rankingSignal) { throw new RuntimeException("Stub!"); }
}

/**
 * This class represents match objects for any snippets that might be present in {@link android.app.appsearch.SearchResults SearchResults} from a query.
 *
 * <p>A {@link android.app.appsearch.SearchResult.MatchInfo MatchInfo} contains either a {@link android.app.appsearch.SearchResult.TextMatchInfo TextMatchInfo} representing a text match
 * snippet, or an {@link android.app.appsearch.SearchResult.EmbeddingMatchInfo EmbeddingMatchInfo} representing an embedding match snippet.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MatchInfo implements android.os.Parcelable {

MatchInfo() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the exact term of the given entry that matched the query. Returns an empty
 * CharSequence if the match is not text-based.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.CharSequence getExactMatch() { throw new RuntimeException("Stub!"); }

/**
 * Gets the {@link android.app.appsearch.SearchResult.MatchRange MatchRange} of the exact term of the given entry that matched the query.
 * Returns [0, 0] if the match is not text-based.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchRange getExactMatchRange() { throw new RuntimeException("Stub!"); }

/**
 * Gets the full text corresponding to the given entry. Returns an empty string if the match
 * is not text-based.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getFullText() { throw new RuntimeException("Stub!"); }

/**
 * Gets the property path corresponding to the given entry.
 *
 * <p>A property path is a '.' - delimited sequence of property names indicating which
 * property in the document these snippets correspond to.
 *
 * <p>Example properties: 'body', 'sender.name', 'sender.emailaddress', etc. For class
 * example 1 this returns "subject"

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPropertyPath() { throw new RuntimeException("Stub!"); }

/**
 * Gets a {@link android.app.appsearch.PropertyPath PropertyPath} object representing the property path corresponding to the
 * given entry.
 *
 * <p>Methods such as {@link android.app.appsearch.GenericDocument#getPropertyDocument GenericDocument.getPropertyDocument} accept a path as a string
 * rather than a {@link android.app.appsearch.PropertyPath PropertyPath} object. However, you may want to manipulate the path
 * before getting a property document. This method returns a {@link android.app.appsearch.PropertyPath PropertyPath} rather
 * than a String for easier path manipulation, which can then be converted to a String.
 *
 * @see #getPropertyPath
 * @see android.app.appsearch.PropertyPath

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PropertyPath getPropertyPathObject() { throw new RuntimeException("Stub!"); }

/**
 * Gets the snippet corresponding to the given entry. Returns an empty CharSequence if the
 * match is not text-based.
 *
 * <p>Snippet - Provides a subset of the content to display. Only populated when requested
 * maxSnippetSize > 0. The size of this content can be changed by {@link android.app.appsearch.SearchSpec.Builder#setMaxSnippetSize  }. Windowing is centered around the middle of the
 * matched token with content on either side clipped to token boundaries.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.CharSequence getSnippet() { throw new RuntimeException("Stub!"); }

/**
 * Gets the snippet {@link android.app.appsearch.SearchResult.MatchRange MatchRange} corresponding to the given entry. Returns [0,0] if
 * the match is not text-based.
 *
 * <p>Only populated when set maxSnippetSize > 0 in {@link android.app.appsearch.SearchSpec.Builder#setMaxSnippetSize  }.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchRange getSnippetRange() { throw new RuntimeException("Stub!"); }

/**
 * Gets the exact term subsequence of the given entry that matched the query. Returns an
 * empty CharSequence if the match is not text-based.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.CharSequence getSubmatch() { throw new RuntimeException("Stub!"); }

/**
 * Gets the {@link android.app.appsearch.SearchResult.MatchRange MatchRange} of the submatch term subsequence of the given entry that
 * matched the query. Returns [0, 0] if the match is not text-based.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchRange getSubmatchRange() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchResult.MatchInfo> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.app.appsearch.SearchResult.MatchInfo MatchInfo} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.SearchResult.MatchInfo.Builder MatchInfo.Builder} reporting a match with the given property
 * path.
 *
 * <p>A property path is a dot-delimited sequence of property names indicating which
 * property in the document these snippets correspond to.
 *
 * <p>Example properties: 'body', 'sender.name', 'sender.emailaddress', etc. For class
 * example 1, this returns "subject".
 *
 * @param propertyPath A dot-delimited sequence of property names indicating which
 *     property in the document these snippets correspond to.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyPath) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchResult.MatchInfo MatchInfo}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchInfo build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the exact {@link android.app.appsearch.SearchResult.MatchRange MatchRange} corresponding to the given entry.
 * @param matchRange This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchInfo.Builder setExactMatchRange(@android.annotation.NonNull android.app.appsearch.SearchResult.MatchRange matchRange) { throw new RuntimeException("Stub!"); }

/**
 * Sets the snippet {@link android.app.appsearch.SearchResult.MatchRange MatchRange} corresponding to the given entry.
 * @param matchRange This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchInfo.Builder setSnippetRange(@android.annotation.NonNull android.app.appsearch.SearchResult.MatchRange matchRange) { throw new RuntimeException("Stub!"); }

/**
 * Sets the submatch {@link android.app.appsearch.SearchResult.MatchRange MatchRange} corresponding to the given entry.
 * @param matchRange This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResult.MatchInfo.Builder setSubmatchRange(@android.annotation.NonNull android.app.appsearch.SearchResult.MatchRange matchRange) { throw new RuntimeException("Stub!"); }
}

}

/**
 * Class providing the position range of a text match information.
 *
 * <p>All ranges are finite, and the left side of the range is always {@code <=} the right side
 * of the range.
 *
 * <p>Example: MatchRange(0, 100) represents hundred ints from 0 to 99."
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MatchRange {

/**
 * Creates a new immutable range.
 *
 * <p>The endpoints are {@code [start, end)}; that is the range is bounded. {@code start}
 * must be lesser or equal to {@code end}.
 *
 * @param start The start point (inclusive)
 * @param end The end point (exclusive)
 */

public MatchRange(int start, int end) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

/** Gets the end point (exclusive). */

public int getEnd() { throw new RuntimeException("Stub!"); }

/** Gets the start point (inclusive). */

public int getStart() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

}

