/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/**
 * Represents data specific to a component ad that is necessary for ad selection and rendering. This
 * is to support use case for ads composed of multiple pieces, such as an ad displaying multiple
 * products at once.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ComponentAdData implements android.os.Parcelable {

/**
 * Constructs a {@link android.adservices.common.ComponentAdData ComponentAdData} object.
 *
 * <p>This object represents a single component within a multi-part ad. The provided render URI
 * points to the resources needed to render this component. Both the URI and the resources to
 * render the component are provided by the buyer ad tech.
 *
 * @param renderUri the URI that points to the component's rendering resources.
 * This value cannot be {@code null}.
 * @param adRenderId the component ad render ID used in the auction flow to identify the ad and
 *     bid on it. This ID is typically generated by the buyer ad tech and is also used to track
 *     the individual component within the larger ad.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided {@code adRenderId} is empty.
 */

public ComponentAdData(@android.annotation.NonNull android.net.Uri renderUri, @android.annotation.NonNull java.lang.String adRenderId) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets the component ad render id for server auctions.
 *
 * <p>Ad render id is collected for each {@link android.adservices.common.ComponentAdData ComponentAdData} when server auction request is
 * received.
 *
 * <p>The overall size of the Custom Audience is limited. The size of this field is considered
 * using {@link java.lang.String#getBytes() String.getBytes()} in {@code UTF-8} encoding.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAdRenderId() { throw new RuntimeException("Stub!"); }

/**
 * Gets the URI that points to the component's rendering resources.
 *
 * <p>Both the URI and the resources it points to are provided by the buyer ad tech.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getRenderUri() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.ComponentAdData> CREATOR;
static { CREATOR = null; }
}

