/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;


/** Represents input parameters to the setAppInstallAdvertiser API. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SetAppInstallAdvertisersRequest {

SetAppInstallAdvertisersRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of advertisers that will be able to run app install filters based on this
 * app's presence on the device after a call to SetAppInstallAdvertisers is made with this as
 * input.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.adservices.common.AdTechIdentifier> getAdvertisers() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.SetAppInstallAdvertisersRequest SetAppInstallAdvertisersRequest} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SetAppInstallAdvertisersRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets list of allowed advertisers. See {@link android.adservices.adselection.SetAppInstallAdvertisersRequest  #getAdvertisers()}
 
 * @param advertisers This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SetAppInstallAdvertisersRequest.Builder setAdvertisers(@android.annotation.NonNull java.util.Set<android.adservices.common.AdTechIdentifier> advertisers) { throw new RuntimeException("Stub!"); }
}

}

