/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Network;
import android.net.http.HeaderBlock;
import android.net.http.HttpException;
import android.net.http.UploadDataProvider;
import android.net.http.UrlResponseInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;

public abstract class UrlRequest {
    public static final int REQUEST_PRIORITY_HIGHEST = 4;
    public static final int REQUEST_PRIORITY_IDLE = 0;
    public static final int REQUEST_PRIORITY_LOW = 2;
    public static final int REQUEST_PRIORITY_LOWEST = 1;
    public static final int REQUEST_PRIORITY_MEDIUM = 3;

    UrlRequest() {
        throw new RuntimeException("Stub!");
    }

    public abstract void cancel();

    public abstract void followRedirect();

    @NonNull
    public abstract HeaderBlock getHeaders();

    @Nullable
    public abstract String getHttpMethod();

    public abstract int getPriority();

    public abstract void getStatus(@NonNull StatusListener var1);

    public abstract int getTrafficStatsTag();

    public abstract int getTrafficStatsUid();

    public abstract boolean hasTrafficStatsTag();

    public abstract boolean hasTrafficStatsUid();

    public abstract boolean isCacheDisabled();

    public abstract boolean isDirectExecutorAllowed();

    public abstract boolean isDone();

    public abstract void read(@NonNull ByteBuffer var1);

    public abstract void start();

    public static interface StatusListener {
        public void onStatus(int var1);
    }

    public static class Status {
        public static final int CONNECTING = 10;
        public static final int DOWNLOADING_PAC_FILE = 5;
        public static final int ESTABLISHING_PROXY_TUNNEL = 8;
        public static final int IDLE = 0;
        public static final int INVALID = -1;
        public static final int READING_RESPONSE = 14;
        public static final int RESOLVING_HOST = 9;
        public static final int RESOLVING_HOST_IN_PAC_FILE = 7;
        public static final int RESOLVING_PROXY_FOR_URL = 6;
        public static final int SENDING_REQUEST = 12;
        public static final int SSL_HANDSHAKE = 11;
        public static final int WAITING_FOR_AVAILABLE_SOCKET = 2;
        public static final int WAITING_FOR_CACHE = 4;
        public static final int WAITING_FOR_DELEGATE = 3;
        public static final int WAITING_FOR_RESPONSE = 13;
        public static final int WAITING_FOR_STALLED_SOCKET_POOL = 1;

        Status() {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface Callback {
        public void onCanceled(@NonNull UrlRequest var1, @Nullable UrlResponseInfo var2);

        public void onFailed(@NonNull UrlRequest var1, @Nullable UrlResponseInfo var2, @NonNull HttpException var3);

        public void onReadCompleted(@NonNull UrlRequest var1, @NonNull UrlResponseInfo var2, @NonNull ByteBuffer var3) throws Exception;

        public void onRedirectReceived(@NonNull UrlRequest var1, @NonNull UrlResponseInfo var2, @NonNull String var3) throws Exception;

        public void onResponseStarted(@NonNull UrlRequest var1, @NonNull UrlResponseInfo var2) throws Exception;

        public void onSucceeded(@NonNull UrlRequest var1, @NonNull UrlResponseInfo var2);
    }

    public static abstract class Builder {
        Builder() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public abstract Builder addHeader(@NonNull String var1, @NonNull String var2);

        @NonNull
        public abstract Builder bindToNetwork(@Nullable Network var1);

        @NonNull
        public abstract UrlRequest build();

        @NonNull
        public abstract Builder setCacheDisabled(boolean var1);

        @NonNull
        public abstract Builder setDirectExecutorAllowed(boolean var1);

        @NonNull
        public abstract Builder setHttpMethod(@NonNull String var1);

        @NonNull
        public abstract Builder setPriority(int var1);

        @NonNull
        public abstract Builder setTrafficStatsTag(int var1);

        @NonNull
        public abstract Builder setTrafficStatsUid(int var1);

        @NonNull
        public abstract Builder setUploadDataProvider(@NonNull UploadDataProvider var1, @NonNull Executor var2);
    }
}

